/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.link;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.fw.rcs.PathManager;
import com.ibm.hwmca.fw.rcs.RcsConfig;
import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.conndata.ConnectivityInfo;
import com.ibm.hwmca.fw.rcs.conndata.ServerInfo;
import com.ibm.hwmca.fw.rcs.link.LinkAlreadyActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.util.Trace;

public class InternetVpnLink
extends RcsLink {
    private static final String TRACE_MASKT = "XRCSLIVT";
    private static final String TRACE_MASKF = "XRCSLIVF";
    private static final String TRACE_MASKD = "XRCSLIVD";
    private static InternetVpnLink instance;
    private boolean failOver;

    protected InternetVpnLink() {
        this.maxOpenPaths = 5;
        this.failOver = false;
        Trace.trace(TRACE_MASKT, "<-> InternetVpnLink()");
    }

    public static RcsLink getInstance() {
        if (instance == null) {
            instance = new InternetVpnLink();
        }
        Trace.trace(TRACE_MASKT, "<-> getInstance() [" + instance + "]");
        return instance;
    }

    public void activate() throws LinkAlreadyActiveException, LinkFailedException, LinkNotConfiguredException {
        Trace.trace(TRACE_MASKT, "--> activate()");
        if (this.active) {
            this.deactivate();
        }
        if (!this.isConfigured()) {
            throw new LinkNotConfiguredException();
        }
        int rc = 0;
        try {
            this.active = false;
            for (int sdc = 1; sdc <= 2; ++sdc) {
                if (this.failOver && sdc == 1) continue;
                PathManager.getPathManager().setSdc(sdc);
                CustomerInfoData custData = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
                String country = custData.getSystemCountryCode();
                String region = custData.getSystemSubdivisionCode();
                ConnectivityInfo connData = ConnectionInfoManager.getConnectionInfoManager().getConnectivityInfo(country, region);
                ServerInfo serverInfo = connData.getServerInfo("Server_VPN");
                String vpnServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                serverInfo = connData.getServerInfo("Server_RS3");
                String rs3Server = serverInfo == null ? "" : serverInfo.getIpAddress();
                String rs3Port = serverInfo == null ? "" : String.valueOf(serverInfo.getPort());
                serverInfo = connData.getServerInfo("Server_SA");
                String sdrServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                serverInfo = connData.getServerInfo("Server_SAS");
                String sasServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                serverInfo = connData.getServerInfo("Server_URSF");
                String ursfServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                RcsConfig cfg = RcsConfig.getRcsConfig();
                cfg.setTemporaryConfigValue("vpn_server", vpnServer);
                cfg.setTemporaryConfigValue("host_rs3", rs3Server);
                cfg.setTemporaryConfigValue("port_rs3", rs3Port);
                cfg.setTemporaryConfigValue("host_sdr", sdrServer);
                cfg.setTemporaryConfigValue("host_sas", sasServer);
                cfg.setTemporaryConfigValue("host_ursf", ursfServer);
                if (PathManager.getPathManager().isRemoteServiceCall() && !vpnServer.equals("207.25.252.196") || (rc = RcsControl.startVpn()) != 0) continue;
                this.active = true;
                break;
            }
            if (!this.active) {
                throw new LinkFailedException("Failed to start VPN (RC: " + rc + ")");
            }
        }
        catch (LinkFailedException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
            throw new LinkFailedException(e);
        }
        Trace.trace(TRACE_MASKT, "<-- activate()");
    }

    public void deactivate() {
        Trace.trace(TRACE_MASKT, "--> deactivate()");
        PathManager.getPathManager().setRemoteServiceCall(false);
        try {
            RcsControl.stopVpn();
            this.active = false;
            this.failOver = false;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- deactivate()");
    }

    public boolean fail() {
        Trace.trace(TRACE_MASKT, "--> fail()");
        boolean fail = false;
        if (!this.failOver) {
            if (this.active) {
                this.deactivate();
            }
            this.failOver = true;
            fail = true;
        } else if (this.active) {
            this.deactivate();
        }
        Trace.trace(TRACE_MASKT, "<-- fail() [" + fail + "]");
        return fail;
    }

    public boolean isConfigured() {
        OutboundConfigData data = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
        boolean configured = data.isCallHomeServer() && data.isAllowInternet() && super.isConfigured();
        Trace.trace(TRACE_MASKT, "<-> isConfigured() [" + configured + "]");
        return configured;
    }

    public boolean isHighPerformanceLink() {
        Trace.trace(TRACE_MASKT, "<-> isHighPerformanceLink() [true]");
        return true;
    }
}

